/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu.pdu;

import apicore.mu.pdu.Header;
import apicore.ptmp.PtmpBuffer;

public class SegmentHeader
extends Header {
    public int srcPort = 0;
    public int dstPort = 0;
    public int segmentChecksum = 0;

    public void serialize(PtmpBuffer ptmpBuffer) {
        super.serialize(ptmpBuffer);
        ptmpBuffer.putInt(this.srcPort);
        ptmpBuffer.putInt(this.dstPort);
        ptmpBuffer.putInt(this.segmentChecksum);
    }

    public boolean deserialize(PtmpBuffer ptmpBuffer) {
        if (!super.deserialize(ptmpBuffer)) {
            return false;
        }
        try {
            this.srcPort = ptmpBuffer.getInt();
            this.dstPort = ptmpBuffer.getInt();
            this.segmentChecksum = ptmpBuffer.getInt();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static SegmentHeader create(PtmpBuffer ptmpBuffer) {
        SegmentHeader segmentHeader = new SegmentHeader();
        if (segmentHeader.deserialize(ptmpBuffer)) {
            return segmentHeader;
        }
        return null;
    }

    public String getTypeName() {
        return "CSegmentHeader";
    }

    public String toString() {
        String string = "";
        string = string + super.toString();
        string = string + "[SegmentHeader: srcPort=" + this.srcPort + ", dstPort=" + this.dstPort + ", segmentChecksum=" + this.segmentChecksum + "]";
        return string;
    }
}

